/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.utility.collections.mappings;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public interface PairStream<K, V> {
    public static <K, V> PairStream<K, V> from(Map<K, V> map) {
        return PairStream.from(map.entrySet().stream());
    }

    public static <K, V> PairStream<K, V> from(Stream<Map.Entry<K, V>> s) {
        return () -> s;
    }

    public static <K, V> PairStream<K, V> from(Stream<K> s, Function<? super K, ? extends V> f) {
        return () -> s.map((? super T k) -> new AbstractMap.SimpleImmutableEntry(k, f.apply((Object)k)));
    }

    default public PairStream<K, V> distinct() {
        return PairStream.from(this.entries().distinct());
    }

    default public PairStream<K, V> peek(BiConsumer<? super K, ? super V> action) {
        return PairStream.from(this.entries().peek((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    default public PairStream<K, V> skip(long n) {
        return PairStream.from(this.entries().skip(n));
    }

    default public PairStream<K, V> limit(long maxSize) {
        return PairStream.from(this.entries().limit(maxSize));
    }

    default public PairStream<K, V> filterKey(Predicate<? super K> mapper) {
        return PairStream.from(this.entries().filter((? super T e) -> mapper.test((Object)e.getKey())));
    }

    default public PairStream<K, V> filterValue(Predicate<? super V> mapper) {
        return PairStream.from(this.entries().filter((? super T e) -> mapper.test((Object)e.getValue())));
    }

    default public PairStream<K, V> filter(BiPredicate<? super K, ? super V> mapper) {
        return PairStream.from(this.entries().filter((? super T e) -> mapper.test((Object)e.getKey(), (Object)e.getValue())));
    }

    default public <R> PairStream<R, V> mapKey(Function<? super K, ? extends R> mapper) {
        return PairStream.from(this.entries().map((? super T e) -> new AbstractMap.SimpleImmutableEntry(mapper.apply((Object)e.getKey()), e.getValue())));
    }

    default public <R> PairStream<K, R> mapValue(Function<? super V, ? extends R> mapper) {
        return PairStream.from(this.entries().map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e.getKey(), mapper.apply((Object)e.getValue()))));
    }

    default public <R> Stream<R> map(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return this.entries().map((? super T e) -> mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    default public DoubleStream mapToDouble(ToDoubleBiFunction<? super K, ? super V> mapper) {
        return this.entries().mapToDouble((? super T e) -> mapper.applyAsDouble((Object)e.getKey(), (Object)e.getValue()));
    }

    default public IntStream mapToInt(ToIntBiFunction<? super K, ? super V> mapper) {
        return this.entries().mapToInt((? super T e) -> mapper.applyAsInt((Object)e.getKey(), (Object)e.getValue()));
    }

    default public LongStream mapToLong(ToLongBiFunction<? super K, ? super V> mapper) {
        return this.entries().mapToLong((? super T e) -> mapper.applyAsLong((Object)e.getKey(), (Object)e.getValue()));
    }

    default public <RK, RV> PairStream<RK, RV> flatMap(BiFunction<? super K, ? super V, ? extends PairStream<RK, RV>> mapper) {
        return PairStream.from(this.entries().flatMap((? super T e) -> ((PairStream)mapper.apply((Object)e.getKey(), (Object)e.getValue())).entries()));
    }

    default public <R> Stream<R> flatMapToObj(BiFunction<? super K, ? super V, ? extends Stream<R>> mapper) {
        return this.entries().flatMap((? super T e) -> (Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    default public DoubleStream flatMapToDouble(BiFunction<? super K, ? super V, ? extends DoubleStream> mapper) {
        return this.entries().flatMapToDouble((? super T e) -> (DoubleStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    default public IntStream flatMapToInt(BiFunction<? super K, ? super V, ? extends IntStream> mapper) {
        return this.entries().flatMapToInt((? super T e) -> (IntStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    default public LongStream flatMapToLong(BiFunction<? super K, ? super V, ? extends LongStream> mapper) {
        return this.entries().flatMapToLong((? super T e) -> (LongStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    default public PairStream<K, V> sortedByKey(Comparator<? super K> comparator) {
        return PairStream.from(this.entries().sorted(Map.Entry.comparingByKey(comparator)));
    }

    default public PairStream<K, V> sortedByValue(Comparator<? super V> comparator) {
        return PairStream.from(this.entries().sorted(Map.Entry.comparingByValue(comparator)));
    }

    default public boolean allMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.entries().allMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    default public boolean anyMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.entries().anyMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    default public boolean noneMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.entries().noneMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    default public long count() {
        return this.entries().count();
    }

    public Stream<Map.Entry<K, V>> entries();

    default public Stream<K> keys() {
        return this.entries().map(Map.Entry::getKey);
    }

    default public Stream<V> values() {
        return this.entries().map(Map.Entry::getValue);
    }

    default public Optional<Map.Entry<K, V>> maxByKey(Comparator<? super K> comparator) {
        return this.entries().max(Map.Entry.comparingByKey(comparator));
    }

    default public Optional<Map.Entry<K, V>> maxByValue(Comparator<? super V> comparator) {
        return this.entries().max(Map.Entry.comparingByValue(comparator));
    }

    default public Optional<Map.Entry<K, V>> minByKey(Comparator<? super K> comparator) {
        return this.entries().min(Map.Entry.comparingByKey(comparator));
    }

    default public Optional<Map.Entry<K, V>> minByValue(Comparator<? super V> comparator) {
        return this.entries().min(Map.Entry.comparingByValue(comparator));
    }

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        this.entries().forEach((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    default public void forEachOrdered(BiConsumer<? super K, ? super V> action) {
        this.entries().forEachOrdered((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    default public Map<K, V> toMap() {
        return this.entries().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public Map<K, V> toMap(BinaryOperator<V> valAccum) {
        return this.entries().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, valAccum));
    }
}

